! If <useActiveDamping>, reads <gamma> values from FN_GAMMA
! If file could not be opened, Message is called and gamma is set to zero
! If read error occurs, Message is called and program is terminated

SUBROUTINE ReadNonLinearityFile
	USE Declare
	USE FilesModule
	USE MessageModule
	USE DFLIB
	IMPLICIT NONE
	INTEGER ios
	integer(4) :: messageboxQQresult
	CHARACTER(12) IntToString

	IF (useActiveDamping) THEN
		ALLOCATE (gamma(n), STAT = err)
		IF (err /= 0) CALL AllocationError

		gamma = 0
		OPEN (FH_GAMMA, FILE = FN_GAMMA, IOSTAT = ios)
	
		IF (ios /=0) THEN
			CALL Message (MessageText(GAMMAFILEOPENERROR), MESSAGETITLE(GAMMAFILEOPENERROR)) 
		ELSE
			DO i=1, n
				READ (FH_GAMMA, *, IOSTAT = ios) gamma(i)
				IF (ios /=0) THEN
					messageboxQQresult = MESSAGEBOXQQ ("Only " // TRIM(IntToString(i-1)) // " gamma-values for active damping could be read, while "//TRIM(IntToString(n)) // " values\nare needed (one for every section). The gamma's for the last sections\nwill be set to zero (so no active damping)"C, "Error reading "//FN_GAMMA // ""C, MB$OK .OR. MB$ICONINFORMATION) 
					EXIT
				ENDIF
			ENDDO
			CLOSE (FH_GAMMA)
		ENDIF
	ENDIF

END SUBROUTINE ReadNonLinearityFile